import os
from setuptools import find_packages, setup

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

requires = ['requests']
setup(
    name='avia-feature-flag-api-client',
    version='0.8',
    packages=find_packages(),
    include_package_data=True,
    license='BSD License',
    description='A client for the feature flag api',
    long_description=README,
    author='Mangin Alexander',
    author_email='mangin@yandex-team.ru',
    classifiers=[
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
    ],
    install_requires=requires,
)
