# -*- coding: utf-8 -*-
from six import iteritems


def skip_None_values(d):
    """
    >>> skip_None_values({1: None, 2: 'not None'})
    {2: 'not None'}
    >>> skip_None_values({1, None})
    set([1])
    >>> skip_None_values([1, None, '2', None])
    [1, '2']
    >>> skip_None_values('s')
    's'
    """
    if isinstance(d, dict):
        # Type(d) allow to work with dict subclasses and return same type
        return type(d)(
            filter(lambda (key, val): val is not None, iteritems(d))
        )
    elif isinstance(d, (set, list)):
        return type(d)(
            filter(lambda k: k is not None, d)
        )

    return d
