# -*- coding: utf-8 -*-


class GeobaseObject(object):
    def __init__(self, data):
        # type: (dict) -> None
        self._data = data

    def __getattr__(self, item):
        if item not in self._data:
            raise AttributeError('Unknown attribute {}, in {}'.format(item, self._data.keys()))
        return self._data[item]


class GeobaseRegion(GeobaseObject):
    @property
    def ename(self):
        return str(self.en_name)


class GeobaseLinguistics(GeobaseObject):
    def __getattr__(self, item):
        if item in self._data:
            return self._data[item]

        case = item + '_case'
        if case in self._data:
            return self._data[case]

        raise AttributeError('Unknown attribute {}, in {}'.format(item, self._data.keys()))
