# -*- coding: utf-8 -*-
import os
from setuptools import find_packages, setup

__version__ = '1.0.16'

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    __doc__ = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

with open('requirements.txt') as fp:
    _install_requires = fp.read().splitlines()

setup(
    name='avia-http-geobase',
    version=__version__,
    packages=find_packages(),
    include_package_data=True,
    license='BSD License',
    description='Http Geobase',
    long_description=__doc__,
    author='Avia team',
    author_email='avia-dev@yandex-team.ru',
    classifiers=[
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
    ],
    install_requires=_install_requires,
)
