# coding=utf-8
from __future__ import unicode_literals

import datetime
import logging


def safe_tables_for_date_range(yc, path, begin, end):
    """
    :param yt.wrapper yc:
    :param six.text_type path:
    :param datetime.date begin:
    :param datetime.date end:
    :rtype typing.List[six.text_type]:
    """
    tables = []
    for t in yc.search(path, node_type='table'):
        try:
            if begin <= _table_date(t) <= end:
                tables.append(t)
        except:
            logging.getLogger(__name__).exception('Error getting safe tables for date range')
            continue

    return tables


def _table_date(table):
    return datetime.datetime.strptime(table.split('/')[-1], '%Y-%m-%d').date()
