# -*- coding: utf-8 -*-
import logging
import subprocess


def dump_db(conn_params, output_file, mysqldump_executable='mysqldump'):
    dump_calls = get_dump_db_command(
        conn_params,
        mysqldump_executable=mysqldump_executable,
    )
    try:
        subprocess.check_output(
            '{ ' + dump_calls + ' }' +
            ' > {output_file}'.format(output_file=output_file),
            shell=True,
            stderr=subprocess.STDOUT,
        )
    except subprocess.CalledProcessError as error:
        raise RuntimeError(error.output)


def get_dump_db_command(conn_params, mysqldump_executable='mysqldump'):
    options = '--extended-insert --create-options --max-allowed-packet=120M --net-buffer-length=8M --set-gtid-purged=OFF'
    dump_calls = '{mysqldump} -h {host} --port {port} -u {user} --password={{password}} {options} {db_name};\n'.format(
        mysqldump=mysqldump_executable,
        host=conn_params['host'],
        port=conn_params['port'],
        user=conn_params['user'],
        db_name=conn_params['db'],
        options=options + ' --no-data --ignore-table={}.{}'.format(conn_params['db'], 'django_migrations')
    )
    dump_calls += '{mysqldump} -h {host} --port {port} -u {user} --password={{password}} {options} {db_name} {table};'.format(
        mysqldump=mysqldump_executable,
        host=conn_params['host'],
        port=conn_params['port'],
        user=conn_params['user'],
        db_name=conn_params['db'],
        options=options,
        table='django_migrations'
    )
    logging.info('Dump command: %s', dump_calls)
    return dump_calls.format(password=conn_params['passwd'])
