# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.avia.price_prediction.api.v1.check_price_pb2 import TPricePrediction


class PriceCategory(object):
    UNKNOWN = 'unknown'
    GOOD = 'good'
    BAD = 'bad'

    @classmethod
    def from_proto(cls, category):
        if category == TPricePrediction.CATEGORY_GOOD:
            return cls.GOOD
        elif category == TPricePrediction.CATEGORY_BAD:
            return cls.BAD
        else:
            return cls.UNKNOWN


class PricePredictionServerEnvironment(object):
    PRODUCTION = 'production'
    PREPRODUCTION = 'preproduction'
    TESTING = 'testing'
    UNSTABLE = 'unstable'


STAGE_BY_ENVIRONMENT = {
    PricePredictionServerEnvironment.PRODUCTION: 'avia-price-prediction-production.api',
    PricePredictionServerEnvironment.PREPRODUCTION: 'avia-price-prediction-preproduction.api',
    PricePredictionServerEnvironment.TESTING: 'avia-price-prediction-testing.api',
    PricePredictionServerEnvironment.UNSTABLE: 'avia-price-prediction-unstable.api',
}
