import logging

from requests.exceptions import ProxyError
from retrying import retry

from travel.avia.library.python.proxy_pool.proxy_pool import ProxyPool

log = logging.getLogger(__name__)


class PartnerProxy(object):
    def __init__(self, proxy_pool):
        # type: (ProxyPool) -> None
        self._proxy_pool = proxy_pool

    @retry(
        retry_on_exception=lambda e: isinstance(e, ProxyError),
        stop_max_attempt_number=3,
        wait_exponential_multiplier=100,
    )
    def request(self, method, *args, **kwargs):
        try:
            proxy_uri = self.get_proxy()
            if proxy_uri:
                http_proxy_uri = proxy_uri.get_http_uri()
                kwargs['proxies'] = {
                    'http': http_proxy_uri,
                    'https': http_proxy_uri,
                }
            return method(*args, **kwargs)
        except ProxyError as e:
            if 'NewConnectionError' in str(e.message):
                self._proxy_pool.reload_proxies()
            raise e

    def get_proxy(self):
        return self._proxy_pool.get_proxy()
