# -*- coding: utf-8 -*-
from travel.library.python.avia_mdb_replica_info.avia_mdb_replica_info import MdbAPI
from travel.library.python.avia_mdb_replica_info.avia_mdb_replica_info.const import REDIS_API_BASE_URL


class RedisConfigurator(object):
    def __init__(
        self,
        redis_cluster_id,
        redis_port,
        redis_password,
        oauth_token,
        service_name,
        socket_timeout,
        monitoring_sensor_prefix='cache',
        monitoring_metric_queue=None,
    ):
        self.redis_cluster_id = redis_cluster_id
        self.redis_port = redis_port
        self.redis_password = redis_password
        self.oauth_token = oauth_token
        self.service_name = service_name
        self.socket_timeout = socket_timeout
        self.monitoring_sensor_prefix = monitoring_sensor_prefix
        self.monitoring_metric_queue = monitoring_metric_queue

    def _get_redis_hosts(self):
        cluster_id = self.redis_cluster_id
        port = self.redis_port
        default_master = 'c-{}.rw.db.yandex.net'.format(cluster_id)
        default_slaves = ['c-{}.rw.db.yandex.net'.format(cluster_id)]
        mdb_api = MdbAPI(
            api_base_url=REDIS_API_BASE_URL,
            oauth_token=self.oauth_token,
        )
        mdb_api.add_default_cluster_info(
            cluster_id=cluster_id,
            master_hostname=default_master,
            hostnames=default_slaves,
        )
        hosts = mdb_api.get_cluster_info(cluster_id)
        return [(instance.hostname, port) for instance in hosts.instances]

    def configure_redis(self):
        redis_hosts = self._get_redis_hosts()
        return {
            'default': {
                'BACKEND': 'django_redis.cache.RedisCache',  # noqa
                'LOCATION': redis_hosts,
                'LONG_TIMEOUT': 86400,
                'OPTIONS': {
                    'server_max_value_length': 134217728,
                    'SENTINEL_SERVICE_NAME': self.service_name,
                    'SOCKET_TIMEOUT': self.socket_timeout,
                    'CLIENT_CLASS': 'travel.avia.library.python.redis.client.RedisClient',
                    'PASSWORD': self.redis_password,
                    'HOSTS': redis_hosts,
                    'monitoring_sensor_prefix': self.monitoring_sensor_prefix,
                    'monitoring_metric_queue': self.monitoring_metric_queue,
                },
                'TIMEOUT': 60,
            }
        }

    def configure_redis_master_only(self):
        config = self.configure_redis()
        config['default']['OPTIONS']['MASTER_ONLY'] = True
        return config
