# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import yt.wrapper as yt


def precached(client, reference_yt_path='//home/rasp/reference'):
    memo = {}
    for partner in client.read_table(yt.TablePath(yt.ypath_join(reference_yt_path, 'partner'))):
        if partner['code'] and partner['partner_id'] and partner['billing_order_id']:
            memo[partner['code'].lower()] = (
                int(partner['partner_id']),
                int(partner['billing_order_id']),
            )
    return memo


class PartnerCache(object):
    def __init__(self, yt):
        self._memo = None
        self.yt = yt

    def partner_id_bundle(self, code):
        code = code.lower()
        if self._memo is None:
            self._memo = precached(self.yt)
        try:
            return self._memo[code]
        except KeyError:
            raise KeyError(
                'Settlement for code {!r} is not found'.format(code)
            )
