# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from typing import Optional  # noqa

import yt.wrapper as yt

from travel.avia.library.python.references.helpers import point_key_to_id


class StationToSettlementCache(object):
    def __init__(self, rows):
        self._by_id = {}
        self._fill_maps(rows)

    def _fill_maps(self, rows):
        self._by_id = {point_key_to_id(row['station_id']): point_key_to_id(row['city_id']) for row in rows}

    def settlement_id_by_id(self, station_id, raise_on_unknown=True):
        # type: (int, bool) -> Optional[int]
        try:
            return self._by_id[station_id]
        except KeyError:
            if raise_on_unknown:
                raise KeyError(
                    'Settlement for id {!r} is not found'.format(station_id)
                )
            return None


def create_station_to_settlement_cache(yt_client, reference_yt_path='//home/rasp/reference'):
    # type: (yt.YtClient, str) -> StationToSettlementCache
    rows = yt_client.read_table(yt.TablePath(yt.ypath_join(reference_yt_path, 'station2settlement')))
    return StationToSettlementCache(rows)
