# -*- coding: utf-8 -*-

import logging

from django.db import models


log = logging.getLogger(__name__)


class BaseZNodeRoute2(models.Model):
    """
    Поисковый индекс точка-точка.
    """

    route = models.ForeignKey('www.Route')
    thread = models.ForeignKey('www.RThread')

    settlement_from = models.ForeignKey('www.Settlement', related_name='%(app_label)s_outgoing_noderoutes2', null=True)
    station_from = models.ForeignKey('www.Station', related_name='%(app_label)s_outgoing_noderoutes2')
    rtstation_from = models.ForeignKey('www.RTStation', related_name='%(app_label)s_outgoing_noderoutes2', null=True)

    settlement_to = models.ForeignKey('www.Settlement', related_name='%(app_label)s_incoming_noderoutes2', null=True)
    station_to = models.ForeignKey('www.Station', related_name='%(app_label)s_incoming_noderoutes2')
    rtstation_to = models.ForeignKey('www.RTStation', related_name='%(app_label)s_incoming_noderoutes2', null=True)

    stops_translations = models.TextField(null=False, default='')

    class Meta:
        app_label = 'www'
        index_together = [
            ['settlement_from', 'settlement_to'],
            ['settlement_from', 'station_to'],
            ['station_from', 'settlement_to'],
            ['station_from', 'station_to'],
        ]
        abstract = True
