from functools import partial
from enum import Enum

from travel.avia.library.python.shared_dicts.common import iter_protobuf_data as common_iter
from travel.library.python.dicts.avia.company_repository import CompanyRepository
from travel.library.python.dicts.avia.settlement_repository import SettlementRepository
from travel.library.python.dicts.avia.station_repository import StationRepository
from travel.library.python.dicts.avia.station_to_settlement_repository import StationToSettlementRepository
from travel.library.python.dicts.avia.fare_families_repository import FareFamiliesRepository


class ResourceType(Enum):
    TRAVEL_DICT_AVIA_COMPANY_PROD = 'TRAVEL_DICT_AVIA_COMPANY_PROD'
    TRAVEL_DICT_AVIA_SETTLEMENTS_PROD = 'TRAVEL_DICT_AVIA_SETTLEMENTS_PROD'
    TRAVEL_DICT_AVIA_STATION_PROD = 'TRAVEL_DICT_AVIA_STATION_PROD'
    TRAVEL_DICT_AVIA_STATION_TO_SETTLEMENT_PROD = 'TRAVEL_DICT_AVIA_STATION_TO_SETTLEMENT_PROD'
    TRAVEL_DICT_AVIA_FARE_FAMILIES_PROD = 'TRAVEL_DICT_AVIA_FARE_FAMILIES_PROD'


resource_type_to_repo = {
    ResourceType.TRAVEL_DICT_AVIA_COMPANY_PROD: CompanyRepository,
    ResourceType.TRAVEL_DICT_AVIA_SETTLEMENTS_PROD: SettlementRepository,
    ResourceType.TRAVEL_DICT_AVIA_STATION_PROD: StationRepository,
    ResourceType.TRAVEL_DICT_AVIA_FARE_FAMILIES_PROD: FareFamiliesRepository,
    ResourceType.TRAVEL_DICT_AVIA_STATION_TO_SETTLEMENT_PROD: StationToSettlementRepository,
}

iter_protobuf_data = partial(common_iter, resource_type_to_repo)
