# encoding: utf-8
from travel.avia.library.python.shared_dicts.avia import iter_protobuf_data, ResourceType


class FareFamilyCache:
    SANDBOX_RESOURCE = ResourceType.TRAVEL_DICT_AVIA_FARE_FAMILIES_PROD

    def __init__(self, logger, oauth=None):
        self.oauth = oauth
        self.fare_families_by_id = {}
        self.logger = logger

    def get_fare_families_by_airline_id(self, airline_id):
        if not airline_id:
            return None
        if airline_id in self.fare_families_by_id:
            return self.fare_families_by_id[airline_id]
        self.logger.warning('No fare families for airline_id %d in the cache', airline_id)

    def clear_cache(self):
        self.fare_families_by_id = {}

    def populate(self):
        self.fare_families_by_id = self.build_cache(self.oauth)
        self.logger.info('populated cache with %d airlines with fare families', len(self.fare_families_by_id))

    def update_cache(self):
        try:
            self.fare_families_by_id = self.build_cache(self.oauth)
        except Exception as e:
            self.logger.error('Failed to update fare families cache. Will continue using old cache. Reason: %s', e)

        self.logger.info('repopulated cache with %d airlines with fare families', len(self.fare_families_by_id))

    @classmethod
    def build_cache(cls, oauth=None):
        fare_families_by_id = {}

        for fare_families in iter_protobuf_data(FareFamilyCache.SANDBOX_RESOURCE, oauth):
            fare_families_by_id[fare_families.AirlineId] = fare_families.Values
        return fare_families_by_id
