# encoding: utf-8
from travel.avia.library.python.shared_dicts.rasp import iter_protobuf_data, ResourceType


class RegionCache:
    SANDBOX_RESOURCE = ResourceType.TRAVEL_DICT_RASP_REGION_PROD

    def __init__(self, logger):
        self.region_by_id = {}
        self.logger = logger

    def get_region_by_id(self, region_id):
        if not region_id:
            return None
        if region_id in self.region_by_id:
            return self.region_by_id[region_id]
        self.logger.warning('No region for region_id %d in the cache', region_id)

    def clear_cache(self):
        self.region_by_id = {}

    def populate(self):
        self.region_by_id = self.build_cache()
        self.logger.info('populated cache with %d regions', len(self.region_by_id))

    def update_cache(self):
        try:
            self.region_by_id = self.build_cache()
        except Exception as e:
            self.logger.error('Failed to update region cache. Will continue using old cache. Reason: %s', e)

        self.logger.info('repopulated cache with %d regions', len(self.region_by_id))

    @classmethod
    def build_cache(cls):
        region_by_id = {}

        for region in iter_protobuf_data(RegionCache.SANDBOX_RESOURCE):
            region_by_id[region.Id] = region
        return region_by_id
