from travel.avia.library.python.shared_dicts.rasp import iter_protobuf_data, ResourceType


class StationCache:
    SANDBOX_RESOURCE = ResourceType.TRAVEL_DICT_RASP_STATION_PROD

    def __init__(self, logger):
        self.id_to_station = {}
        self.slug_to_station = {}
        self.logger = logger

    def get_station_by_id(self, station_id):
        if not station_id:
            return None
        if station_id in self.id_to_station:
            return self.id_to_station[station_id]
        self.logger.warning('No code for station_id %d in the cache', station_id)

    def get_station_by_slug(self, slug):
        if not slug:
            return None
        return self.slug_to_station.get(slug)

    def clear_cache(self):
        self.id_to_station = {}
        self.slug_to_station = {}

    def populate(self):
        self.id_to_station, self.slug_to_station = self.build_cache()
        self.logger.info(
            'populated cache with %d stations',
            len(self.id_to_station),
        )

    def update_cache(self):
        try:
            self.populate()
        except Exception as e:
            self.logger.error('Failed to update station cache. Will continue using old cache. Reason: %s', e)

    @staticmethod
    def build_cache():
        id_to_station = {}
        slug_to_station = {}

        stations = iter_protobuf_data(StationCache.SANDBOX_RESOURCE)
        for station in stations:
            if station.Slug:
                slug_to_station[station.Slug] = station
            id_to_station[station.Id] = station

        return id_to_station, slug_to_station
