# encoding: utf-8
from travel.avia.library.python.shared_dicts.avia import iter_protobuf_data, ResourceType


class StationToSettlementCache:
    SANDBOX_RESOURCE = ResourceType.TRAVEL_DICT_AVIA_STATION_TO_SETTLEMENT_PROD

    def __init__(self, logger, oauth=None):
        self.settlement_id_by_station_id = {}
        self.oauth = oauth
        self.logger = logger

    def get_settlement_id_by_station_id(self, station_id):
        if not station_id:
            return None
        if station_id in self.settlement_id_by_station_id:
            return self.settlement_id_by_station_id[station_id]
        self.logger.warning('No settlement_id for station_id %d in the cache', station_id)

    def clear_cache(self):
        self.settlement_id_by_station_id = {}

    def populate(self):
        self.settlement_id_by_station_id = self.build_cache(self.oauth)
        self.logger.info('populated cache with %d station-to-settlements', len(self.settlement_id_by_station_id))

    def update_cache(self):
        try:
            self.settlement_id_by_station_id = self.build_cache(self.oauth)
        except Exception as e:
            self.logger.error('Failed to update station2settlement cache. Will continue using old cache. Reason: %s', e)

        self.logger.info('repopulated cache with %d station-to-settlements', len(self.settlement_id_by_station_id))

    @classmethod
    def build_cache(cls, oauth=None):
        settlement_id_by_station_id = {}

        for row in iter_protobuf_data(StationToSettlementCache.SANDBOX_RESOURCE, oauth):
            settlement_id_by_station_id[row.StationId] = row.SettlementId

        return settlement_id_by_station_id
