# encoding: utf-8
from travel.avia.library.python.shared_dicts.rasp import iter_protobuf_data, ResourceType


class TimezoneCache:
    SANDBOX_RESOURCE = ResourceType.TRAVEL_DICT_RASP_TIMEZONE_PROD

    def __init__(self, logger):
        self.timezone_by_id = {}
        self.logger = logger

    def get_timezone_by_id(self, timezone_id):
        if not timezone_id:
            return None
        if timezone_id in self.timezone_by_id:
            return self.timezone_by_id[timezone_id]
        self.logger.warning('No timezone for timezone_id %d in the cache', timezone_id)

    def clear_cache(self):
        self.timezone_by_id = {}

    def populate(self):
        self.timezone_by_id = self.build_cache()
        self.logger.info('populated cache with %d timezones', len(self.timezone_by_id))

    def update_cache(self):
        try:
            self.timezone_by_id = self.build_cache()
        except Exception as e:
            self.logger.error('Failed to update timezone cache. Will continue using old cache. Reason: %s', e)

        self.logger.info('repopulated cache with %d timezones', len(self.timezone_by_id))

    @classmethod
    def build_cache(cls):
        timezone_by_id = {}

        for timezone in iter_protobuf_data(TimezoneCache.SANDBOX_RESOURCE):
            timezone_by_id[timezone.Id] = timezone
        return timezone_by_id
