# encoding: utf-8
from travel.avia.library.python.shared_dicts.rasp import iter_protobuf_data, ResourceType


class TransportModelCache:
    SANDBOX_RESOURCE = ResourceType.TRAVEL_DICT_RASP_TRANSPORT_MODEL_PROD

    def __init__(self, logger, oauth=None):
        self.transport_model_by_id = {}
        self.oauth = oauth
        self.logger = logger

    def get_transport_model_by_id(self, transport_model_id):
        if not transport_model_id:
            return None
        if transport_model_id in self.transport_model_by_id:
            return self.transport_model_by_id[transport_model_id]
        self.logger.warning('No transport_model for transport_model_id %d in the cache', transport_model_id)

    def clear_cache(self):
        self.transport_model_by_id = {}

    def populate(self):
        self.transport_model_by_id = self.build_cache(self.oauth)
        self.logger.info('populated cache with %d transport models', len(self.transport_model_by_id))

    def update_cache(self):
        try:
            self.transport_model_by_id = self.build_cache(self.oauth)
        except Exception as e:
            self.logger.error('Failed to update transport models cache. Will continue using old cache. Reason: %s', e)

        self.logger.info('repopulated cache with %d transport models', len(self.transport_model_by_id))

    @classmethod
    def build_cache(cls, oauth=None):
        transport_model_by_id = {}

        for row in iter_protobuf_data(TransportModelCache.SANDBOX_RESOURCE, oauth):
            transport_model_by_id[row.Id] = row

        return transport_model_by_id
