from functools import partial
from enum import Enum

from travel.avia.library.python.shared_dicts.common import iter_protobuf_data as common_iter
from travel.avia.library.python.shared_dicts.common import get_repository as common_repository_getter
from travel.library.python.dicts.aviaalliance_repository import AviaAllianceRepository
from travel.library.python.dicts.carrier_repository import CarrierRepository
from travel.library.python.dicts.country_repository import CountryRepository
from travel.library.python.dicts.currency_repository import CurrencyRepository
from travel.library.python.dicts.district_repository import DistrictRepository
from travel.library.python.dicts.pointsynonym_repository import PointSynonymRepository
from travel.library.python.dicts.region_repository import RegionRepository
from travel.library.python.dicts.settlement_repository import SettlementRepository
from travel.library.python.dicts.station_code_repository import StationCodeRepository
from travel.library.python.dicts.station_express_alias_repository import StationExpressAliasRepository
from travel.library.python.dicts.station_repository import StationRepository
from travel.library.python.dicts.station_to_settlement_repository import StationToSettlementRepository
from travel.library.python.dicts.thread_repository import ThreadRepository
from travel.library.python.dicts.thread_station_repository import ThreadStationRepository
from travel.library.python.dicts.timezone_repository import TimezoneRepository
from travel.library.python.dicts.transport_model_repository import TransportModelRepository


class ResourceType(Enum):
    TRAVEL_DICT_RASP_AVIAALLIANCE_PROD = 'TRAVEL_DICT_RASP_AVIAALLIANCE_PROD'
    TRAVEL_DICT_RASP_CARRIER_PROD = 'TRAVEL_DICT_RASP_CARRIER_PROD'
    TRAVEL_DICT_RASP_COUNTRY_PROD = 'TRAVEL_DICT_RASP_COUNTRY_PROD'
    TRAVEL_DICT_RASP_CURRENCY_PROD = 'TRAVEL_DICT_RASP_CURRENCY_PROD'
    TRAVEL_DICT_RASP_DISTRICT_PROD = 'TRAVEL_DICT_RASP_DISTRICT_PROD'
    TRAVEL_DICT_RASP_POINTSYNONYM_PROD = 'TRAVEL_DICT_RASP_POINTSYNONYM_PROD'
    TRAVEL_DICT_RASP_REGION_PROD = 'TRAVEL_DICT_RASP_REGION_PROD'
    TRAVEL_DICT_RASP_SETTLEMENT_PROD = 'TRAVEL_DICT_RASP_SETTLEMENT_PROD'
    TRAVEL_DICT_RASP_STATION_CODE_PROD = 'TRAVEL_DICT_RASP_STATION_CODE_PROD'
    TRAVEL_DICT_RASP_STATION_EXPRESS_ALIAS_PROD = 'TRAVEL_DICT_RASP_STATION_EXPRESS_ALIAS_PROD'
    TRAVEL_DICT_RASP_STATION_PROD = 'TRAVEL_DICT_RASP_STATION_PROD'
    TRAVEL_DICT_RASP_STATION_TO_SETTLEMENT_PROD = 'TRAVEL_DICT_RASP_STATION_TO_SETTLEMENT_PROD'
    TRAVEL_DICT_RASP_THREAD_PROD = 'TRAVEL_DICT_RASP_THREAD_PROD'
    TRAVEL_DICT_RASP_THREAD_STATION_PROD = 'TRAVEL_DICT_RASP_THREAD_STATION_PROD'
    TRAVEL_DICT_RASP_TIMEZONE_PROD = 'TRAVEL_DICT_RASP_TIMEZONE_PROD'
    TRAVEL_DICT_RASP_TRANSPORT_MODEL_PROD = 'TRAVEL_DICT_RASP_TRANSPORT_MODEL_PROD'


resource_type_to_repo = {
    ResourceType.TRAVEL_DICT_RASP_AVIAALLIANCE_PROD: AviaAllianceRepository,
    ResourceType.TRAVEL_DICT_RASP_CARRIER_PROD: CarrierRepository,
    ResourceType.TRAVEL_DICT_RASP_COUNTRY_PROD: CountryRepository,
    ResourceType.TRAVEL_DICT_RASP_CURRENCY_PROD: CurrencyRepository,
    ResourceType.TRAVEL_DICT_RASP_DISTRICT_PROD: DistrictRepository,
    ResourceType.TRAVEL_DICT_RASP_POINTSYNONYM_PROD: PointSynonymRepository,
    ResourceType.TRAVEL_DICT_RASP_REGION_PROD: RegionRepository,
    ResourceType.TRAVEL_DICT_RASP_SETTLEMENT_PROD: SettlementRepository,
    ResourceType.TRAVEL_DICT_RASP_STATION_CODE_PROD: StationCodeRepository,
    ResourceType.TRAVEL_DICT_RASP_STATION_EXPRESS_ALIAS_PROD: StationExpressAliasRepository,
    ResourceType.TRAVEL_DICT_RASP_STATION_PROD: StationRepository,
    ResourceType.TRAVEL_DICT_RASP_STATION_TO_SETTLEMENT_PROD: StationToSettlementRepository,
    ResourceType.TRAVEL_DICT_RASP_THREAD_PROD: ThreadRepository,
    ResourceType.TRAVEL_DICT_RASP_THREAD_STATION_PROD: ThreadStationRepository,
    ResourceType.TRAVEL_DICT_RASP_TIMEZONE_PROD: TimezoneRepository,
    ResourceType.TRAVEL_DICT_RASP_TRANSPORT_MODEL_PROD: TransportModelRepository,
}

iter_protobuf_data = partial(common_iter, resource_type_to_repo)
get_repository = partial(common_repository_getter, resource_type_to_repo)
