from ctypes import c_bool
from multiprocessing import Value


class SharedFlag:
    """
    Flag in shared memory for multiprocessing.
    It contains link to memory segment, so it's important to create flag before process fork.
    """

    def __init__(self):
        self._value = Value(c_bool, False)

    def reset(self):
        self._value.value = False

    def is_set(self):
        # typing: () -> bool
        return self._value.value

    def set(self):
        self._value.value = True
