from travel.avia.library.python.proxy_pool.django import partner_proxy
from travel.avia.library.python.sirena_client import SirenaClient

_generator = None


def _generator_client(host_provider, port_name, client_id):
    # type: (Callable[[],ProxyHost], str, int)->Generator[SirenaClient, None, None]
    host = host_provider()
    while host:
        yield SirenaClient(host.get_ftp_host(), port_name, client_id)
        host = host_provider()


def sirena_client_factory(client_id):
    # type: (int)->Callable[[],SirenaClient]
    generator = _generator_client(
        host_provider=partner_proxy.get_proxy,
        port_name='production',
        client_id=client_id,
    )
    return lambda: next(generator)
