# -*- coding: utf-8 -*-
import logging
import sys
from argparse import ArgumentParser

from sandbox.common.proxy import OAuth
from sandbox.common.rest import Client as SandboxClient
from sandbox.projects.Travel.resources import dicts
from travel.avia.library.python.sandbox.resource_fetcher import ResourceFetcher
from travel.avia.library.python.sitemap_generator.lib.generator import SitemapGenerator
from travel.library.python.dicts.avia.top_flight_repository import TopFlightRepository
from travel.library.python.dicts.settlement_repository import SettlementRepository


def main():
    logging.basicConfig(level=logging.INFO, format="%(asctime)-15s | %(module)s | %(levelname)s | %(message)s",
                        stream=sys.stdout)
    logging.getLogger('yt.packages.urllib3.connectionpool').setLevel(logging.WARNING)

    parser = ArgumentParser()
    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token', required=True)
    parser.add_argument('--sandbox-token', required=True)
    parser.add_argument('--portal-url', default='https://travel.yandex.ru')
    parser.add_argument('--s3-endpoint', default='https://s3.mds.yandex.net')
    parser.add_argument('--s3-bucket', default='avia-indexer')
    parser.add_argument('--s3-prefix', default='sitemaps')
    parser.add_argument('--s3-access-key', required=True)
    parser.add_argument('--s3-access-secret-key', required=True)
    parser.add_argument('--changefreq')
    parser.add_argument('--add-lastmod', action='store_true')
    parser.add_argument('--gen-flight', action='store_true')
    parser.add_argument('--add-avia-root', action='store_true')
    parser.add_argument('--gen-landing-city-to', action='store_true')
    args = parser.parse_args()

    sandbox_oauth = OAuth(args.sandbox_token)
    sandbox_client = SandboxClient(auth=sandbox_oauth)
    resource_fetcher = ResourceFetcher(sandbox_client, sandbox_oauth)

    settlement_repository = SettlementRepository()
    settlement_resource_data = resource_fetcher.fetch_latest_ready(dicts.TRAVEL_DICT_RASP_SETTLEMENT_PROD)
    settlement_repository.load_from_string(settlement_resource_data)

    top_flight_repository = TopFlightRepository()
    top_flight_resource_data = resource_fetcher.fetch_latest_ready(dicts.TRAVEL_DICT_AVIA_TOP_FLIGHT_PROD)
    top_flight_repository.load_from_string(top_flight_resource_data)

    SitemapGenerator(
        portal_url=args.portal_url,
        yt_proxy=args.yt_proxy,
        yt_token=args.yt_token,
        changefreq=args.changefreq,
        add_lastmod=args.add_lastmod,
        s3_endpoint=args.s3_endpoint,
        s3_prefix=args.s3_prefix,
        s3_access_key=args.s3_access_key,
        s3_access_secret_key=args.s3_access_secret_key,
        s3_bucket=args.s3_bucket,
        settlement_repository=settlement_repository,
        top_flight_repository=top_flight_repository,
        need_generate_flight_sitemap=args.gen_flight,
        need_add_avia_root=args.add_avia_root,
        need_generate_city_to_sitemap=args.gen_landing_city_to,
    ).generate()


if __name__ == '__main__':
    main()
