# -*- coding: utf-8 -*-
import unidecode

ALLOWED_URL_SYMBOLS = ' -0123456789abcdefghijklmnopqrstuvwxyz'
REPLACES = {' ': '-'}


def build_slug(title):
    title = title.replace(u'ь', '')  # костыль для починки "уральский" -> "ural'skii". Мягкий знак заменяется на '
    slug = unidecode.unidecode(title).lower()
    slug_chars = []
    allow_next_minus = False
    for ch in slug:
        if ch in ALLOWED_URL_SYMBOLS:
            ch = REPLACES.get(ch, ch)
        else:
            ch = '-'
        if ch != '-' or allow_next_minus:
            slug_chars.append(ch)
        allow_next_minus = ch != '-'
    while slug_chars and slug_chars[-1] == '-':
        slug_chars.pop()
    slug = ''.join(slug_chars)
    return slug
