# -*- coding: utf-8 -*-


from importlib import import_module

from django.conf import settings


def load_class(path):
    module, klass = path.rsplit('.', 1)
    return getattr(import_module(module), klass, None)


AbstractSchedule = load_class(getattr(settings, 'STATIONSCHEDULE_BASE_CLASS',
                                      'travel.avia.library.python.stationschedule.type.base.AbstractSchedule'))
