# -*- coding: utf-8 -*-

import datetime

from django.conf import settings

from travel.avia.library.python.common.models_utils.i18n import RouteLTitle
from travel.avia.library.python.common.xgettext.i18n import mark_gettext, dynamic_gettext


EVENT_ARRIVAL = 'arrival'
EVENT_DEPARTURE = 'departure'


TRANSPORT_STATUSES = {
    'wait': mark_gettext(u'ожидается'),
    'late': mark_gettext(u'задержан'),
    'departure': mark_gettext(u'отправлен'),
    'arrive': mark_gettext(u'прибыл'),
    'cancelled': mark_gettext(u'отменён'),
    'unknown': mark_gettext(u'неизвестен'),
    'nodata': mark_gettext(u'нет данных'),
}

TRANSPORT_STATUSES_DEP = {
    'wait': mark_gettext(u'ожидается'),
    'late': mark_gettext(u'задерживается'),
    'departure': mark_gettext(u'отправлен'),
    'arrive': mark_gettext(u'прибыл'),
    'cancelled': mark_gettext(u'отменён'),
    'unknown': mark_gettext(u'неизвестен'),
    'rasch': mark_gettext(u'отправлен'),
    'nodata': mark_gettext(u'нет данных')
}

TRANSPORT_STATUSES_ARR = {
    'wait': mark_gettext(u'ожидается'),
    'late': mark_gettext(u'опаздывает'),
    'departure': mark_gettext(u'отправлен'),
    'arrive': mark_gettext(u'прибыл'),
    'cancelled': mark_gettext(u'отменён'),
    'unknown': mark_gettext(u'неизвестен'),
    'rasch': mark_gettext(u'прибыл'),
    'nodata': mark_gettext(u'нет данных')
}

UNKNOWN_TYPE_NAME = mark_gettext(u'Неизвестное направление')

TIMEDELTA_ONE_DAY = datetime.timedelta(days=1)

TIME_FOUR_HOURS = datetime.time(4, 0)


def add_schedule_local_title(schedule):
    threads = []
    threads.extend([s.thread for s in schedule if s.thread])
    RouteLTitle.fetch([thread.L_title for thread in threads])

    for s in schedule:
        s.title = s.thread and s.thread.L_title()


def settlement_or_station_title(station):
    if not station:
        return None

    return station.settlement.L_title() if station.settlement else station.L_title()


def status_is_actual(status_code, manual_status, scheduled, expected, lmt, local_now):
    if manual_status is not None:
        return True

    if lmt and (local_now - lmt) <= datetime.timedelta(minutes=30):
        return True

    if status_code == 'cancelled':
        return True

    if lmt and lmt > expected:
        return True

    return scheduled > local_now


def tablo_status(manual_status, scheduled, expected, cancelled, event, lmt, local_now, station=None):
    # RASP-13834 При указании значения "Нет данных" всем рейсам на странице табло пишем "нет данных", вне зависимости от
    # того, что прислал партнёр, а фактическое время не выводим
    if station and station.tablo_state == 'nodata':
        status_code = 'nodata'
        return status_code, dynamic_gettext(TRANSPORT_STATUSES[status_code])

    # Эти статусы доверяем агентам
    if cancelled:
        # Отменен - всегда актуален
        status_code = 'cancelled'
        return status_code, dynamic_gettext(TRANSPORT_STATUSES[status_code])

    if expected is None:
        return 'nodata', dynamic_gettext(TRANSPORT_STATUSES['nodata'])

    # Если транспорт задерживается и разница между текущим временем и
    # фактическим временем прибытия не велика, оставляем статус задерживается
    still_late = False
    if (
        expected > (scheduled + settings.ALLOWABLE_DELAY)
        and (local_now - expected) < settings.SWITCH_STATUS_AFTER
    ):
        status_code = 'late'
        still_late = True

    # Если не опаздывает
    if not still_late:
        # Если событие уже произошло
        if expected < local_now:
            if event == EVENT_ARRIVAL:
                status_code = 'arrive'
            else:
                status_code = 'departure'
        else:
            status_code = 'wait'

    if not status_is_actual(status_code, manual_status, scheduled, expected, lmt, local_now):
        # RASP-9960 вернуть псевдо-табло для вокзалов
        # в табло жд-станции в режиме "только статусы" вместо "нет данных" выводить "отправлен"
        if station and station.tablo_state == 'statuses' and station.t_type_id == 1:
            if event == EVENT_DEPARTURE:
                status_code = 'departure'
            else:
                status_code = 'arrive'
        else:
            return 'nodata', dynamic_gettext(TRANSPORT_STATUSES['nodata'])

    if event == EVENT_ARRIVAL:
        return status_code, dynamic_gettext(TRANSPORT_STATUSES_DEP[status_code])
    elif event == EVENT_DEPARTURE:
        return status_code, dynamic_gettext(TRANSPORT_STATUSES_ARR[status_code])
