from typing import Dict

import requests


class TankerClient:
    def __init__(self, tanker_url, oauth):
        self.tanker_url = tanker_url
        self.oauth = oauth

    def load_keyset(self, project_id, keyset_id, lang='ru', branch_id='master'):
        # type: (str, str, str, str) -> Dict[str, str]
        url = '{}/keysets/json/'.format(self.tanker_url)
        query_params = {
            'language': lang,
            'project-id': project_id,
            'branch-id': branch_id,
            'keyset-id': keyset_id,
            'status': 'unapproved',
            'no-comments': 'true',
            'flat-keyset': 'true',
        }
        response = requests.get(url, params=query_params, headers={'Authorization': 'OAuth {}'.format(self.oauth)})
        response.raise_for_status()
        return response.json()[lang]
