# -*- coding: utf-8 -*-
from travel.avia.library.python.common.models.service import Service

from travel.avia.library.python.ticket_daemon.memo import memoize, SimpleWarmGroup

services_warm_group = SimpleWarmGroup('services')


@services_warm_group
@memoize()
def _services_by_code():
    return {
        service.code: service
        for service in Service.objects.all().namedtuples(
            'id', 'code', 'is_mobile', 'allow_custom_store_time',
            'limited', 'multiple', 'team__code',
            computational={
                'project_group': (lambda row: row[-1]),  # alias
            },
        )
    }


@services_warm_group
@memoize()
def _multiple_services():
    return {s.code: s for s in _services_by_code().itervalues() if s.multiple}


def _get_multiple_allowed_service(full_code):
    for code_prefix, service in _multiple_services().iteritems():
        if full_code.startswith(code_prefix):
            return service
    return None


def get_service_by_code(code):
    return _services_by_code().get(code) or _get_multiple_allowed_service(code)
