import time


def log_elapsed_time(logger, statsd_prefix=None):
    from statsd.defaults.django import statsd

    def _log_elapsed_time(func):
        def wrapper(*args, **kwargs):
            ts = time.time()
            result = func(*args, **kwargs)
            elapsed = time.time() - ts
            logger.info('{} {}'.format(statsd_prefix or func.__name__, elapsed))
            if statsd_prefix is not None:
                statsd.timing(statsd_prefix, elapsed * 1000)
            return result
        return wrapper
    return _log_elapsed_time
