# -*- coding: utf-8 -*-
from travel.avia.library.python.ticket_daemon.protobuf_converting.big_wizard.filters import (
    AirlineFilter, AirportFilter, BaggageFilter, TimeFilter, TransferFilter
)


KWARGS_FILTERS = {
    'transfer_filters': TransferFilter,
    'time_filters': TimeFilter,
    'airports_filters': AirportFilter,
}
ARG_FILTERS = {
    'with_baggage': BaggageFilter,
    'airlines': AirlineFilter,
}


class FiltersParser(object):
    @staticmethod
    def parse_filters(filters):
        """

        :param dict filters:
        :rtype: list of ticket_daemon_lib.protobuf_converting.big_wizard.filters.Filter
        """
        return [
            FiltersParser._create_filter(f_name, f_args)
            for f_name, f_args in filters.iteritems()
        ]

    @staticmethod
    def _create_filter(f_name, params):
        if f_name in KWARGS_FILTERS:
            return KWARGS_FILTERS[f_name](**params)

        elif f_name in ARG_FILTERS:
            return ARG_FILTERS[f_name](params)
        else:
            # logger.warning('Requested unknown filter %s', f_name)
            return lambda fares, datum: fares
