# -*- coding: utf-8 -*-
import os

import ydb

from travel.avia.library.python.ticket_daemon import date as date_utils


CLASSES_MAP = {
    'economy': 1,
    'business': 2,
}


def to_days(date_):
    if date_ is None:
        return 0
    return (date_ - date_utils.EPOCH_DATE).days


def now_in_days():
    return (date_utils.get_utc_now().date() - date_utils.EPOCH_DATE).days


def passengers_integer_key(query):
    return int('%d%d%d' % (query.adults, query.children, query.infants))


def get_klass_id(klass):
    return CLASSES_MAP[klass]


def is_directory_exists(driver, path):
    try:
        return driver.scheme_client.describe_path(path).is_directory()
    except ydb.SchemeError:
        return False


def ensure_path_exists(driver, database, path):
    paths_to_create = list()
    path = path.rstrip("/")
    while path not in ("", database):
        full_path = os.path.join(database, path)
        if is_directory_exists(driver, full_path):
            break
        paths_to_create.append(full_path)
        path = os.path.dirname(path).rstrip("/")

    while len(paths_to_create) > 0:
        full_path = paths_to_create.pop(-1)
        driver.scheme_client.make_directory(full_path)


class TooManyFunctionCallsException(Exception):
    pass
