import datetime
from typing import Dict


MONTHS_GENITIVE_CASE = {
    1: 'января',
    2: 'февраля',
    3: 'марта',
    4: 'апреля',
    5: 'мая',
    6: 'июня',
    7: 'июля',
    8: 'августа',
    9: 'сентября',
    10: 'октября',
    11: 'ноября',
    12: 'декабря',
}


def to_ru_str(date: datetime.date, month_dict: Dict[int, str], cut_year_if_current: bool, show_year_text: bool):
    result = f'{date.day} {month_dict[date.month]}'
    if not cut_year_if_current or datetime.datetime.now().year != date.year:
        result += f' {date.year}'
        if show_year_text:
            result += ' года'
    return result
