from enum import Enum

from travel.avia.library.python.urls.city_landing import TravelAviaCityLanding  # noqa
from travel.avia.library.python.urls.route_landing import TravelAviaRouteLanding
from travel.avia.library.python.urls.search import TravelAviaSearch, TravelAviaPrefilledFields  # noqa


class Environment(Enum):
    TESTING = 1
    PRODUCTION = 2


_travel_hosts = {
    Environment.TESTING: 'travel-test.yandex.ru',
    Environment.PRODUCTION: 'travel.yandex.ru',
}


def travel_avia_route_landing(environment):
    # type: (Environment) -> TravelAviaRouteLanding
    return TravelAviaRouteLanding(_travel_hosts[environment])


def travel_avia_search(environment):
    # type: (Environment) -> TravelAviaSearch
    return TravelAviaSearch(_travel_hosts[environment])
