from travel.avia.library.python.urls.errors import MalformedUrlParameterValue
from travel.avia.library.python.urls.travel_base import TravelBase


class TravelAviaCityLanding(TravelBase):
    URL_TEMPLATE = 'https://{travel_host}/avia/flights-to/{to_slug}/'

    def url(self, to_slug):
        # type: (str)->str
        if not to_slug:
            raise MalformedUrlParameterValue('to_slug should not be null or empty')
        return self.URL_TEMPLATE.format(
            travel_host=self.travel_host,
            to_slug=to_slug,
        )
