from travel.avia.library.python.urls.errors import MalformedUrlParameterValue
from travel.avia.library.python.urls.travel_base import TravelBase


class TravelAviaRouteLanding(TravelBase):
    URL_TEMPLATE = 'https://{travel_host}/avia/routes/{from_slug}--{to_slug}/'

    def url(self, from_slug, to_slug):
        # type: (str, str)->str
        if not from_slug:
            raise MalformedUrlParameterValue('from_slug should not be null or empty')
        if not to_slug:
            raise MalformedUrlParameterValue('to_slug should not be null or empty')
        return TravelAviaRouteLanding.URL_TEMPLATE.format(
            travel_host=self.travel_host,
            from_slug=from_slug,
            to_slug=to_slug,
        )
