# -*- encoding: utf-8 -*-
import logging
from datetime import datetime, date
from argparse import ArgumentParser

from travel.avia.log_unknown_fare_codes.lib.pipeline import run_pipeline


def main():
    logging.basicConfig(level=logging.DEBUG)

    parser = ArgumentParser()

    parser.add_argument('--td-api-host', help='ticket-daemon-api host',
                        default='http://ticket-daemon-api.production.avia.yandex.net')
    parser.add_argument('--yt-token', help='YT token', required=True)
    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--variants-log-directory', help='Avia variants log directory',
                        default='//home/logfeller/logs/avia-variants-log/1d')
    parser.add_argument('--output-table', help='Output table path. Temp table will be created by default.',
                        default=None)
    parser.add_argument('--date', help='Date', default=date.today().isoformat())

    arguments = parser.parse_args()

    run_pipeline(
        arguments.td_api_host,
        arguments.yt_token,
        arguments.yt_proxy,
        arguments.variants_log_directory,
        datetime.strptime(arguments.date, '%Y-%m-%d'),
        arguments.output_table_path,
    )


if __name__ == '__main__':
    main()
