#!/usr/bin/env bash
set -e

# команды на случай ошибки
trap 'last_command="$current_command"; current_command="$BASH_COMMAND"' DEBUG
trap 'echo "${last_command}" command failed with exit code "$?".' ERR

get_secret() {
    ya vault get version $1 --json | ya tool jq .value.$2 | tr -d '"'
}

# Sandbox OAuth токен, необходимый для скачивания ресурсов
export SANDBOX_TOKEN="$(get_secret sec-01ffs98ww23vytzg2r52020ngb token)"

# переходим в директорию dev/
cd $(dirname "${BASH_SOURCE[0]}")/..

# скачиваем ресурсы если их нет или они старше одного дня
mkdir -p resources

mkdir -p resources/common_dicts
if [[ ! $(find "./resources/common_dicts.tar.gz" -mtime -1 2> /dev/null) ]]; then
    echo "No up-to-date TRAVEL_RASP_COMMON_DICTS_BUNDLE, downloading from Sandbox"
    curl -H "Authorization: OAuth $SANDBOX_TOKEN" https://proxy.sandbox.yandex-team.ru/last/TRAVEL_RASP_COMMON_DICTS_BUNDLE -o ./resources/common_dicts.tar.gz
    tar -C ./resources/common_dicts -xzvf ./resources/common_dicts.tar.gz > /dev/null
else
    echo "TRAVEL_RASP_COMMON_DICTS_BUNDLE is up-to-date"
fi

echo

if [[ ! $(find "./resources/hotels.bin" -mtime -1 2> /dev/null) ]]; then
    echo "No up-to-date AVIA_HOTELS_REFERENCE, downloading from Sandbox"
    curl -H "Authorization: OAuth $SANDBOX_TOKEN" https://proxy.sandbox.yandex-team.ru/last/AVIA_HOTELS_REFERENCE -o ./resources/hotels.bin
else
    echo "AVIA_HOTELS_REFERENCE is up-to-date"
fi
