from typing import Optional
import logging

from yt.wrapper import YtClient, TablePath
from travel.avia.personalization.hotels_reference.proto.hotel_pb2 import Hotels, Hotel

logger = logging.getLogger(__name__)


def read_hotels(yt_client, path='//home/travel/prod/general/altay_mappings/latest/permalink_to_hotel_info', limit=None):
    # type: (YtClient, str, Optional[int]) -> Hotels
    hotels = Hotels()
    for i, row in enumerate(
        yt_client.read_table(TablePath(path, columns=('permalink', 'geoid', 'lat', 'lon',)))
    ):
        if row.get('geoid') is None:
            continue
        if limit is not None and len(hotels.Hotels) == limit:
            break
        if i and i % 100000 == 0:
            logger.debug('got %d hotels', i)
        hotel = Hotel()
        hotel.Permalink = row['permalink']
        hotel.GeoId = row['geoid']
        hotel.Latitude = row['lat']
        hotel.Longitude = row['lon']
        hotels.Hotels.append(hotel)
    return hotels
