package api

import (
	"a.yandex-team.ru/travel/avia/library/go/probes"
	"a.yandex-team.ru/travel/avia/personalization/internal/app"
	"a.yandex-team.ru/travel/avia/personalization/internal/caches/references"
	"a.yandex-team.ru/travel/avia/personalization/internal/lib/ydbutil"
	"a.yandex-team.ru/travel/avia/personalization/internal/services/dynamicresources"
	"a.yandex-team.ru/travel/avia/personalization/internal/tables"
	grpcserver "a.yandex-team.ru/travel/library/go/grpcutil/server"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
)

type Config struct {
	EnvType          string `config:"YENV_TYPE,required" yaml:"yenv_type"`
	Dicts            references.Config
	DynamicResources dynamicresources.Config `yaml:"dynamic_resources"`
	Logging          logging.Config
	Grpc             grpcserver.GrpcConfig
	HTTP             httpserver.HTTPConfig
	Ydb              ydbutil.Config
	Tvm              app.TvmConfig
	Tables           tables.Config
	Probes           probes.HTTPConfig
}

var Cfg = Config{
	EnvType:          "development",
	Dicts:            references.DefaultConfig,
	DynamicResources: dynamicresources.DefaultConfig,
	Logging:          logging.DefaultConfig,
	Grpc:             grpcserver.DefaultGrpcConfig,
	HTTP:             httpserver.DefaultHTTPConfig,
	Ydb:              ydbutil.DefaultConfig,
	Tvm:              app.DefaultTvmConfig,
	Tables:           tables.DefaultConfig,
	Probes:           probes.DefaultHTTPConfig,
}
