package reader

import (
	"a.yandex-team.ru/travel/avia/personalization/internal/caches/references"
	"a.yandex-team.ru/travel/avia/personalization/internal/lib/ydbutil"
	"a.yandex-team.ru/travel/avia/personalization/internal/logbroker"
	"a.yandex-team.ru/travel/avia/personalization/internal/repositories"
	"a.yandex-team.ru/travel/avia/personalization/internal/services/dynamicresources"
	"a.yandex-team.ru/travel/avia/personalization/internal/services/eventscollector"
	"a.yandex-team.ru/travel/avia/personalization/internal/services/profiling"
	"a.yandex-team.ru/travel/avia/personalization/internal/services/readiness"
	"a.yandex-team.ru/travel/avia/personalization/internal/tables"
	"a.yandex-team.ru/travel/library/go/logging"
)

type Config struct {
	EnvType          string `config:"YENV_TYPE,required" yaml:"yenv_type"`
	Dicts            references.Config
	DynamicResources dynamicresources.Config `yaml:"dynamic_resources"`
	Logging          logging.Config
	Logbroker        logbroker.LogbrokerConfig
	Ydb              ydbutil.Config
	HotelsReference  repositories.HotelsReferenceConfig `yaml:"hotels_reference"`
	Tables           tables.Config
	Profiling        profiling.Config
	Readiness        readiness.Config
	EventsCollector  eventscollector.Config `yaml:"events_collector"`
}

var Cfg = Config{
	EnvType:          "development",
	Dicts:            references.DefaultConfig,
	DynamicResources: dynamicresources.DefaultConfig,
	Logging:          logging.DefaultConfig,
	Logbroker:        logbroker.DefaultConfig,
	Ydb:              ydbutil.DefaultConfig,
	HotelsReference:  repositories.DefaultHotelsReferenceConfig,
	Tables:           tables.DefaultConfig,
	Profiling:        profiling.DefaultConfig,
	Readiness:        readiness.DefaultConfig,
	EventsCollector:  eventscollector.DefaultConfig,
}
