package references

import "a.yandex-team.ru/travel/avia/library/go/dicts"

type Cache interface {
	Precache() error
	Ready() bool
	SetOnFetch(func())
}

type SandboxReference interface {
	GetName() string
	GetResourceType() dicts.ResourceType
	InitCacheContext() CacheContext
	Finalize(CacheContext)
}

type CacheContext interface {
	ProcessRow([]byte) error
}
