package extractors

import (
	"fmt"
)

type ErrStationWithoutSettlement struct {
	stationID int
}

func NewErrStationWithoutSettlement(stationID int) error {
	return &ErrStationWithoutSettlement{stationID: stationID}
}

func (e *ErrStationWithoutSettlement) Error() string {
	return fmt.Sprintf("no settlement for station id: %d", e.stationID)
}
