package extractors

import "a.yandex-team.ru/travel/avia/personalization/internal/caches/references"

type StationIDToSettlementIDMapper struct {
	references *references.Registry
}

func NewStationIDToSettlementIDMapper(references *references.Registry) *StationIDToSettlementIDMapper {
	return &StationIDToSettlementIDMapper{references: references}
}

func (s StationIDToSettlementIDMapper) Map(stationID int32) (settlementID int32, found bool) {
	if stationToSettlement, ok := s.references.StationToSettlements.Get(int(stationID)); ok && stationToSettlement.SettlementId > 0 {
		return stationToSettlement.SettlementId, true
	}
	if station, ok := s.references.Stations.Get(int(stationID)); ok && station.SettlementId > 0 {
		return station.SettlementId, true
	}
	return 0, false
}
