package ydbutil

import (
	"context"
	"time"

	"a.yandex-team.ru/kikimr/public/sdk/go/ydb"
	"a.yandex-team.ru/kikimr/public/sdk/go/ydb/table"
)

type Config struct {
	Address  string `config:"YDB_ADDRESS" yaml:"address"`
	Database string `config:"YDB_DATABASE" yaml:"database"`
	Token    string `config:"YDB_TOKEN,required" yaml:"token"`
}

var DefaultConfig = Config{
	Address:  "ydb-ru-prestable.yandex.net:2135",
	Database: "/ru-prestable/ticket/testing/personalization",
}

func NewConnection(ctx context.Context, config *Config) (table.SessionProvider, error) {
	driver, err := ydb.Dial(
		ctx, config.Address, &ydb.DriverConfig{
			Database: config.Database,
			Credentials: ydb.AuthTokenCredentials{
				AuthToken: config.Token,
			},
		},
	)
	if err != nil {
		return nil, err
	}
	tableClient := table.Client{
		Driver: driver,
	}

	return &table.SessionPool{
		SizeLimit:          -1,           // No limits for pool size.
		KeepAliveBatchSize: -1,           // Keep alive as much as possible number of sessions.
		IdleThreshold:      time.Second,  // Keep alive idle session every second.
		Builder:            &tableClient, // Create new sessions within tableClient.
	}, nil
}
