package metrics

import (
	"time"

	libMetrics "a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/library/go/metrics"
)

const metricsPrefix = "common"

var timingBuckets = libMetrics.MakeExponentialDurationBuckets(time.Millisecond, 1.4, 20)

func WriteTimings(metricName string, start time.Time, tags map[string]string) {
	metrics.GlobalAppMetrics().GetOrCreateHistogram(
		metricsPrefix,
		tags,
		metricName,
		timingBuckets,
	).RecordDuration(time.Since(start))
}

func IncCounterMetric(metricName string, tags map[string]string) {
	metrics.GlobalAppMetrics().GetOrCreateCounter(
		metricsPrefix,
		tags,
		metricName,
	).Inc()
}
