package eventscollector

import (
	"a.yandex-team.ru/travel/avia/personalization/internal/collectors"
	"a.yandex-team.ru/travel/avia/personalization/internal/logbroker"
)

type Config struct {
	AviaUserSearchLog         logbroker.ConsumerConfig `yaml:"avia_user_search_log"`
	AviaWizardQueryLog        logbroker.ConsumerConfig `yaml:"avia_wizard_query_log"`
	CPAOrders                 logbroker.ConsumerConfig `yaml:"cpa_orders"`
	TravelHotelsOfferCacheLog logbroker.ConsumerConfig `yaml:"travel_hotels_offer_cache_log"`
	TravelHotelsSearchLog     logbroker.ConsumerConfig `yaml:"travel_hotels_search_log"`

	TravelHotelsOfferCacheLogCollector collectors.TravelHotelsOfferCacheLogCollectorConfig `yaml:"travel_hotels_offer_cache_log_collector"`

	CollectAviaUserSearch      bool `config:"COLLECT_AVIA_USER_SEARCH" yaml:"collect_avia_user_search"`
	CollectAviaWizardQueryLog  bool `config:"COLLECT_AVIA_WIZARD_QUERY_LOG" yaml:"collect_avia_wizard_query_log"`
	CollectHotelsOfferCacheLog bool `config:"COLLECT_HOTELS_OFFER_CACHE_LOG" yaml:"collect_hotels_offer_cache_log"`
	CollectHotelsSearchLog     bool `config:"COLLECT_HOTELS_SEARCH_LOG" yaml:"collect_hotels_search_log"`
	CollectCPAOrders           bool `config:"COLLECT_CPA_ORDERS" yaml:"collect_cpa_orders"`
}

var DefaultConfig = Config{
	AviaUserSearchLog: logbroker.ConsumerConfig{
		Topic: logbroker.TopicConfig{
			Path:                 "/rasp-front/avia-users-search-log",
			MaxReadSize:          1024 * 1024,
			MaxReadMessagesCount: 100,
		},
		ReadEndpoints:      logbroker.AllLogbrokerEndpoints,
		MinActiveConsumers: 2,
		Name:               "AviaUserSearchLog",
	},
	AviaWizardQueryLog: logbroker.ConsumerConfig{
		Topic: logbroker.TopicConfig{
			Path:                 "/rasp-front/avia-wizard-query-log",
			MaxReadSize:          1024 * 1024,
			MaxReadMessagesCount: 100,
		},
		ReadEndpoints:      logbroker.AllLogbrokerEndpoints,
		MinActiveConsumers: 2,
		Name:               "AviaWizardQueryLog",
	},
	TravelHotelsOfferCacheLog: logbroker.ConsumerConfig{
		Topic: logbroker.TopicConfig{
			Path:                 "/travel/travel-hotels-offercache-log",
			MaxReadSize:          1024 * 1024,
			MaxReadMessagesCount: 100,
		},
		ReadEndpoints:      logbroker.AllLogbrokerEndpoints,
		MinActiveConsumers: 2,
		Name:               "TravelHotelsOfferCacheLog",
	},
	TravelHotelsSearchLog: logbroker.ConsumerConfig{
		Topic: logbroker.TopicConfig{
			Path:                 "/travel/test/api-hotels-search-log",
			MaxReadSize:          1024 * 1024,
			MaxReadMessagesCount: 100,
		},
		ReadEndpoints:      logbroker.AllLogbrokerEndpoints,
		MinActiveConsumers: 2,
		Name:               "TravelHotelsSearchLog",
	},
	CPAOrders: logbroker.ConsumerConfig{
		Topic: logbroker.TopicConfig{
			Path:                 "/travel-cpa/test/order-info-hahn-topic",
			MaxReadSize:          1024 * 1024,
			MaxReadMessagesCount: 100,
		},
		ReadEndpoints:      logbroker.AllLogbrokerEndpoints,
		MinActiveConsumers: 2,
		Name:               "CPAOrders",
	},
}
