package grpc

import (
	"context"

	personalsearchproto "a.yandex-team.ru/travel/avia/personalization/api/personal_search/v2"
	"a.yandex-team.ru/travel/avia/personalization/internal/services/personalsearch"
	"a.yandex-team.ru/travel/avia/personalization/internal/services/personalsearch/models"
)

type EventsBuilder interface {
	GetEvents(context.Context, *personalsearch.Query, uint32) ([]models.Event, error)
}

func getEventTypeProto(entry models.Event) personalsearchproto.EntryType {
	if !entry.Order.IsEmpty() {
		return personalsearchproto.EntryType_ENTRY_TYPE_ORDER
	}
	return personalsearchproto.EntryType_ENTRY_TYPE_SEARCH
}

func mapChildrenAges(ages []int) []int32 {
	result := make([]int32, 0, len(ages))
	for _, age := range ages {
		result = append(result, int32(age))
	}
	return result
}
