package models

import "a.yandex-team.ru/travel/proto/cpa"

type Travelers struct {
	Adults       uint8 `json:"adults"`
	Children     uint8 `json:"children"`
	Infants      uint8 `json:"infants"`
	ChildrenAges []int `json:"children_ages"`
}

type GeoPoint struct {
	PointKey string `json:"pointKey"`
	GeoID    uint64 `json:"geo_id"`
}

type Event struct {
	PointFrom  GeoPoint  `json:"from"`
	PointTo    GeoPoint  `json:"to"`
	When       string    `json:"when"`
	ReturnDate string    `json:"returnDate"`
	Travelers  Travelers `json:"travelers"`
	AviaClass  string    `json:"aviaClass"`
	Order      OrderInfo `json:"order"`
	Service    string    `json:"service"`
	Timestamp  uint32    `json:"timestamp"`
}

type OrderInfo struct {
	ID     string
	Status string
}

func (o OrderInfo) IsEmpty() bool {
	return o.ID == ""
}

func (o OrderInfo) IsConfirmed() bool {
	return o.Status == cpa.EOrderStatus_OS_CONFIRMED.String()
}
