package personalsearch

import (
	"a.yandex-team.ru/travel/avia/personalization/internal/auth"
	"a.yandex-team.ru/travel/avia/personalization/internal/tables"
)

type Query struct {
	AuthType                 auth.Type
	AuthValue                string
	ServiceEventTypePairs    tables.EventServiceTypeToLimit
	TravelService            string
	RemoveUnconfirmedOrders  bool
	RemoveLongTermAviaOrders bool
	RemoveOneDayRoundTrip    bool
	FillAviaReturnDate       bool
	DeduplicateByDirection   bool
}

func NewQuery(
	authType auth.Type,
	authValue string,
	serviceEventTypePairs tables.EventServiceTypeToLimit,
	travelService string,
) *Query {
	return &Query{
		AuthType:                 authType,
		AuthValue:                authValue,
		ServiceEventTypePairs:    serviceEventTypePairs,
		TravelService:            travelService,
		DeduplicateByDirection:   true,
		RemoveUnconfirmedOrders:  true,
		RemoveLongTermAviaOrders: false,
		RemoveOneDayRoundTrip:    false,
		FillAviaReturnDate:       false,
	}
}
