package tables

//go:generate ydbgen -wrap optional

//ydb:gen
//ydb:set wrap:none
type UserEventEntry struct {
	AuthType  uint8  `ydb:"column:auth_type,type:uint8?"`
	AuthValue string `ydb:"column:auth_value,type:utf8?"`
	Service   uint8  `ydb:"column:service,type:uint8?"`
	EventType uint8  `ydb:"column:event_type,type:uint8?"`
	EventKey  string `ydb:"column:event_key,type:utf8?"`
	EventData string `ydb:"column:event_data,type:utf8?"`
	CreatedAt uint32 `ydb:"column:created_at,type:datetime?"`
	ExpiresAt uint32 `ydb:"column:expires_at,type:datetime?"`
}

//ydb:gen scan,value
type UserEventEntries []UserEventEntry
